use derive_new::new;
use rmcp::{
    Error, ServerHandler,
    model::{CallToolResult, Content, Implementation, ServerCapabilities, ServerInfo},
    tool,
};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

#[derive(Debug, Deserialize, Serialize, JsonSchema)]
pub struct McpRequest {
    first: Vec<String>,
    second: Vec<String>,
}

#[derive(Clone, new)]
pub struct McpService;

#[tool(tool_box)]
impl McpService {
    #[tool(description = "Search for implemented symbols in the project")]
    pub async fn search_implemented(
        &self,
        #[tool(aggr)] McpRequest { first, second }: McpRequest,
    ) -> Result<CallToolResult, Error> {
        Ok(CallToolResult::success(vec![Content::text(format!(
            "Params: {:?}, {:?}",
            first, second
        ))]))
    }
}

const NAME: &str = env!("CARGO_PKG_NAME");
const VERSION: &str = env!("CARGO_PKG_VERSION");

#[tool(tool_box)]
impl ServerHandler for McpService {
    fn get_info(&self) -> ServerInfo {
        ServerInfo {
            capabilities: ServerCapabilities::builder().enable_tools().build(),
            server_info: Implementation {
                name: NAME.to_string(),
                version: VERSION.to_string(),
            },
            instructions: Some("Some description.".to_string()),
            ..Default::default()
        }
    }
}
