use std::time::Duration;

use log::info;
use mcp_problem_example::{init_logger, start_mcp_server};
use miette::Result;
use tokio_graceful_shutdown::{SubsystemBuilder, SubsystemHandle, Toplevel};

#[tokio::main]
async fn main() -> Result<()> {
    let _log_guard = init_logger()?;
    info!(
        "Starting server in work directory: {}",
        std::env::current_dir().unwrap().display()
    );

    Toplevel::new(|s: SubsystemHandle| async move {
        s.start(SubsystemBuilder::new("MCP server", async move |subsys| {
            start_mcp_server(subsys).await
        }));
    })
    .catch_signals()
    .handle_shutdown_requests(Duration::from_millis(3000))
    .await
    .map_err(Into::into)
    .inspect(|_| info!("Finall message"))
    .inspect_err(|e| info!("Final message in error case: {:?}", e))
}
