package org.spring.example;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@RunWith(SpringRunner.class)
@WebMvcTest(TestController.class)
public class ResourceBundleTest {
	@Autowired
	private MockMvc mvc;

	//fails with 401 unauthorized + prints:
	//'ResourceBundle [messages] not found for MessageSource: Can't find bundle for base name messages, locale en'
	@Test
	public void testBundle() throws Exception {
		mvc.perform(MockMvcRequestBuilders.get("/test")).andExpect(status().isUnauthorized());
	}
}
