package com.example.demo

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConfigurationPropertiesScan
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.boot.runApplication
import javax.annotation.PostConstruct

@ConfigurationProperties("test")
@ConstructorBinding
class Properties(
    val map: Map<String, String>
)

@SpringBootApplication
@ConfigurationPropertiesScan
class DemoApplication {
    @Autowired
    private lateinit var properties: Properties

    @PostConstruct
    fun postInit() {
        println(properties.map.toString())
    }
}

fun main(args: Array<String>) {
    runApplication<DemoApplication>(*args)
}
