function h=plotStick(points)
% plotStick  plot stick figure of audiomaze mocap
%
%   h=plotStick(points)
%
%
%       points is 3 x 32: {xyz} x #markers
%       h is handle to resulting stick figure

X = defineMocapMarkers; %in the audiomaze subdirectory--make sure in path
markers = X.mocap.markers;

% define connected segments (left shoulder sometimes 9, sometimes 10? 
% reason for doing this, instead of simple point-to-point pairs, is that
% this way ensures if an intermediate point is missing there is no 'gap' in
% the stick figure
segments = {[markers.headOrientation],[markers.rightLeg(1) markers.leftLeg(1)], ...
    [8 markers.rightLeg], [10 markers.leftLeg], [8 markers.rightArm markers.rightHand(end)]};

% define 'nets' or fully connected subsets of point--this 'fills in' the
% feet, head, and hand
nets = { markers.rightHand, [markers.rightFoot markers.rightLeg(end)], ...
    [markers.leftFoot markers.leftLeg(end)], markers.trunk, markers.head };

badMarkers = find(isnan(sum(points,1)));

hold on
h=[];
for i = 1:length(segments)
    toPlot = setdiff(segments{i}, badMarkers);
    if length(toPlot)<2, continue, end
    h0 = jplot3(points(:,toPlot),'r-');
    h = [h h0];
end

for i = 1:length(nets)
    toPlot = setdiff(nets{i}, badMarkers);
    if length(toPlot)<2, continue, end
    for j = 1:length(toPlot)-1
        for k = j+1:length(toPlot)
            h0 = jplot3([points(:,toPlot(j)) points(:,toPlot(k))]','r-');
            h = [h h0];
        end
    end
end

h0 = jplot3(points,'b.');
h = [h h0];