function plotMaze(which_maze)
%plot a maze

% maze dimensions (# cells)
n_rows = 5;
n_cols = 5;

%maze physical size (meters)
wallThickness = 0.1;
headProximityThresh = .15;
%original maze was larger, we're trying a smaller one to avoid marker
%dropout near edges of room--it's worst in northeast corner, which is not
%part of any maze, but also w/sw wall/corner

if 0,
    w = 6;
    h = 6.5;
    handProximityThresh = .3;
else
    w = 5;
    h = 5;
    handProximityThresh = .2;
end


random_seed = 0;
hasExits = false;

%define master state variable
global X;
X=[];
X.which_maze = which_maze;
X.trial_number = 0;
X.debugMaze = false;

% maze geometry parameters
X.mazeinfo = ji_packstruct({'n_rows','n_cols','w','h','wallThickness','handProximityThresh','headProximityThresh','random_seed','hasExits'});

X.inTokenTol = .45; % 1/3m
X.outTokenTol = 1.5; % you must get this far away until you can replay

% determine the 'in wall' proximity threshold according to how max/msp
% understands it (midi units, 0-127)
% the proximity here is 0-1 (once we cross the near wall threshold) so
% we need to map MAX/msp's notion of in the wall to the audiomaze
% engine's notion
MAX_hand_wall_prox_thresh = 90; % got this from the MAX patch
X.hand_in_wall_prox = MAX_hand_wall_prox_thresh/127;

MAX_head_wall_prox_thresh = 90; % got this from the MAX patch
X.head_in_wall_prox = MAX_head_wall_prox_thresh/127;

%% create normalized maze geometry based on X.which_maze
X = makeSimpleMaze(X);

%% make the maze
X.am = audioMaze(X.mazeinfo.h, X.mazeinfo.w, X.mazeinfo.n_rows, X.mazeinfo.n_cols, X.mazeGeometry.maze_lines, X.mazeGeometry.maze_poly_wall, X.mazeGeometry.maze_poly_proximity);

X.am.plotMaze();
hold on;

%% define the tokens (these should be more abstract, but it works ok for now)
if 0,
X.tokens = mazeTokens(X.am, X.mazeGeometry.token_locs, []);

% use this to keep track of endpoints to hit
% of this list
X.tokenReached = zeros(1, length(X.mazeGeometry.token_locs));
X.tokenReached(1) = 1; % ensure that the starting point is 'reached'

% plot tokens on the maze
%start blue
plot(X.tokens.mocapLocs(1,1), X.tokens.mocapLocs(1,2), 'o', 'color', [.5 .5 .9], 'markersize',30, 'linewidth', 3);
%goal(s) red
plot(X.tokens.mocapLocs(2:end,1), X.tokens.mocapLocs(2:end,2), 'o', 'color', [.9 .5 .5], 'markersize',30, 'linewidth', 3);
end

