% 01/29/2020 Makoto. Number of missing markers reported.
% 01/24/2018 Makoto. Updated.
% 01/16/2018 Makoto. Updated.
% 12/22/2017 Makoto. Separate the process into an indepednent function.
% 12/20/2017 Makoto. Updated.
% 09/12/2017 Makoto. Created.

addpath /data/mobi/Audiomaze/makoto/code/phaseSpaceCorrectionTools

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% 1. Interpolate missing channels within subject. %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% List all .set files.
%allSets = dir('/data/mobi/Audiomaze/makoto/p02_fitRigidBody/*.set');
allSets = dir('/data/mobi/Audiomaze/makoto/p02_fitRigidBody/subj829*.set');


% Identify the within-subject files.
setNames  = {allSets.name}';
setNames2 = cell2mat(setNames);
setNames3 = setNames2(:,1:7);
setNames4 = cellstr(setNames3);
[C,IA,IC] = unique(setNames4);
numMissingMarkerList = nan(length(C), 5);

for uniqueSubjIdx = 1:length(C)
    currentSubj   = C(uniqueSubjIdx);
    currentSetIdx = find(IC==uniqueSubjIdx);
    
    % Load all .set from a single subject
    ALLEEG = [];
    for withinSubjSetIdx = 1:length(currentSetIdx)
        EEG = pop_loadset('filename', allSets(currentSetIdx(withinSubjSetIdx)).name, 'filepath', '/data/mobi/Audiomaze/makoto/p02_fitRigidBody', 'loadmode', 'info'); 
        [ALLEEG, EEG, CURRENTSET] = eeg_store( ALLEEG, EEG, 0 );
    end
    
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%')
    disp('%%% 1/5 Process Head. %%%')
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%')
    [ALLEEG, numMissingMarkers] = interpolateRigidBodyAcrossBlocks(ALLEEG, 1:7);
    numMissingMarkerList(uniqueSubjIdx, 1) = numMissingMarkers;
    
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%')
    disp('%%% 2/5 Process Torso. %%%')
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%')
    [ALLEEG, numMissingMarkers] = interpolateRigidBodyAcrossBlocks(ALLEEG, [8:11 21 27]);
    numMissingMarkerList(uniqueSubjIdx, 2) = numMissingMarkers;


    disp('%%%%%%%%%%%%%%%%%%%%%%%%%')
    disp('%%% 3/5 Process Hand. %%%')
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%')
    [ALLEEG, numMissingMarkers] = interpolateRigidBodyAcrossBlocks(ALLEEG, 16:20);
    numMissingMarkerList(uniqueSubjIdx, 3) = numMissingMarkers;

    
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%')
    disp('%%% 4/5 Process R-foot. %%%')
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%')
    [ALLEEG, numMissingMarkers] = interpolateRigidBodyAcrossBlocks(ALLEEG, 23:26);
    numMissingMarkerList(uniqueSubjIdx, 4) = numMissingMarkers;


    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%')
    disp('%%% 5/5 Process L-foot. %%%')
    disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%')
    [ALLEEG, numMissingMarkers] = interpolateRigidBodyAcrossBlocks(ALLEEG, 29:32);
    numMissingMarkerList(uniqueSubjIdx, 5) = numMissingMarkers;
        
    % Save data.
    for saveSetIdx = 1:length(ALLEEG)
        pop_saveset(ALLEEG(saveSetIdx), 'filename', ALLEEG(saveSetIdx).filename, 'filepath', '/data/mobi/Audiomaze/makoto/p03_interpolateWithinSubject');
    end
end 
save /data/mobi/Audiomaze/makoto/code/phaseSpaceCorrectionTools/numMissingMarkerList_withinSubject numMissingMarkerList
disp('Done.')

%%
load /data/mobi/Audiomaze/makoto/code/phaseSpaceCorrectionTools/numMissingMarkerList_withinSubject

figure
barHandle1 = bar(mean(numMissingMarkerList)/12);
hold on
errorbarHandle1 = errorbar(1:5, mean(numMissingMarkerList)/12, std(numMissingMarkerList)/sqrt(size(numMissingMarkerList,1))/12);
set(errorbarHandle1, 'linestyle', 'none', 'color', [0 0 0])
xlim([0.5 5.5])
set(gca, 'xticklabel', {'Head' 'Torso' 'Hand' 'FootR' 'FootL'})
set(barHandle1, 'faceColor', [0.93 0.96 1])
ylabel('Counts of LED markers')
title(sprintf('Mean counts of within-participant missing markers (+/-SE)\nF(4.64)=3.74, p=0.0084'))
set(findall(gcf, '-property', 'fontsize'), 'fontsize', 14)

print -dsvg withinSubjectMissingLED

% Range 0-2.0
% F(4,64) = 3.74, p = 0.0084.
[stats, df, pvals] = statcond({numMissingMarkerList(:,1)'/12 numMissingMarkerList(:,2)'/12 numMissingMarkerList(:,3)'/12 numMissingMarkerList(:,4)'/12 numMissingMarkerList(:,5)'/12}, 'paired', 'on');

min(numMissingMarkerList)/12
max(numMissingMarkerList)/12