% 02/04/2020 Makoto. Further fix made. Re-calculated.
% 01/27/2020 Makoto. Bug fixed. Re-calculated.
% 01/22/2020 Makoto. Used for test.
% 01/22/2017 Makoto. Bug in choosing common channels fixed.
% 12/27/2017 Makoto. Changed to fit rigid body only.
% 12/15/2017 Makoto. Used.
% 09/06/2017 Makoto. Data point rejection based on distance from Head/Torso centroid implemented.
% 08/25/2017 Makoto. Created.

addpath /data/mobi/Audiomaze/makoto/code/phaseSpaceCorrectionTools

% 152, 153, 154 (Subj829) skipped for no reason.
% 173 suffers from 40.9% NaN--but let's give it a try anyway. 
%allSets = dir('/data/mobi/Audiomaze/makoto/p01_imported/subj829*.set');
allSets = dir('/data/mobi/Audiomaze/makoto/p01_imported/*.set');
for setIdx = 1:length(allSets)
    
    % Load .set file.
    EEG = pop_loadset('filename', allSets(setIdx).name, 'filepath', '/data/mobi/Audiomaze/makoto/p01_imported', 'loadmode', 'info');
    
    % Obtain phaseSpace data.
    phaseSpaceData = double(EEG.etc.audiomaze.phaseSpaceData);
    
    % Skip if phaseSpaceData is all zeros.
    if ~any(phaseSpaceData(:))
        continue
    end
    
    % Remove the last channel. Then there are 4 x 32 = 128 time series; x, y, z, and signal quality.
    phaseSpaceData = phaseSpaceData(1:end-1,:);
    phaseSpaceData = reshape(phaseSpaceData, [4 32 size(phaseSpaceData,2)]);
    
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Check if more than 20% of data are all NaN %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    nanCheck             = squeeze(phaseSpaceData(1,:,:));
    validMask            = nanCheck~=0;
    validFrameIdx        = find(sum(validMask));
    theLastValidFrame    = validFrameIdx(end);
    nanMask              = nanCheck(:,1:theLastValidFrame)==0;
    numberOfNanChannels  = sum(nanMask);
    numberOfAllNanFrames = sum(numberOfNanChannels == size(phaseSpaceData,2));
    
%     % 01/22/2018 Makoto. Only if more than 20% of data points are all NaN, skip this data without saving.
%     if numberOfAllNanFrames > theLastValidFrame*0.2
%         continue
%     end
   
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Fit rigid body for the five body parts. %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    lessThanThreeMarkerIdx       = logical(zeros(5, size(phaseSpaceData,3)));
    lessThanThreeLedMarkerLabels = {'Head' 'Torso' 'Hand' 'footR' 'footL'};
    
            %%%%%%%%%%%%%%%%%%%%%
            %%% Process head. %%%
            %%%%%%%%%%%%%%%%%%%%%
            headIdx = [1:7];
            phaseSpaceDataSelected  = phaseSpaceData([1:3], headIdx,:);
            [headCorrected, badIdx] = rigidBodyCorrection(phaseSpaceDataSelected, 5); % 5-Hz lpf for head.
            lessThanThreeMarkerIdx(1,badIdx) = 1;

            %%%%%%%%%%%%%%%%%%%%%%
            %%% Process torso. %%%
            %%%%%%%%%%%%%%%%%%%%%%
            torsoIdx = [8:11 21 27];
            if strcmp(EEG.setname, 'Subj829')
                torsoIdx = [9:11 21 27]; % For Subj829, remove right shoulder.
            end
            phaseSpaceDataSelected   = phaseSpaceData([1:3], torsoIdx,:);
            [torsoCorrected, badIdx] = rigidBodyCorrection(phaseSpaceDataSelected, 5); % 5-Hz lpf for torso.
            lessThanThreeMarkerIdx(2,badIdx) = 1;

            %%%%%%%%%%%%%%%%%%%%%
            %%% Process hand. %%%
            %%%%%%%%%%%%%%%%%%%%%
            handIdx = [16:20];
            phaseSpaceDataSelected  = phaseSpaceData([1:3], handIdx,:);
            [handCorrected, badIdx] = rigidBodyCorrection(phaseSpaceDataSelected, 5); % 5-Hz lpf for head.
            lessThanThreeMarkerIdx(3,badIdx) = 1;
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%% Process right foot. %%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%
            footR_Idx = [23:26];
            phaseSpaceDataSelected    = phaseSpaceData([1:3], footR_Idx,:);
            [footR_Corrected, badIdx] = rigidBodyCorrection(phaseSpaceDataSelected, 5); % 5-Hz lpf for footR.
            lessThanThreeMarkerIdx(4,badIdx) = 1;
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%
            %%% Process left foot. %%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%
            footL_Idx = [29:32];
            phaseSpaceDataSelected    = phaseSpaceData([1:3], footL_Idx,:);
            [footL_Corrected, badIdx] = rigidBodyCorrection(phaseSpaceDataSelected, 5); % 5-Hz lpf for footL.
            lessThanThreeMarkerIdx(5,badIdx) = 1;
    
            
            
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Put them back to the data. %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    rigidBodyFit = phaseSpaceData;
    rigidBodyFit([1:3], headIdx,   :) = headCorrected;
    rigidBodyFit([1:3], torsoIdx,  :) = torsoCorrected;
    rigidBodyFit([1:3], handIdx,   :) = handCorrected;
    rigidBodyFit([1:3], footR_Idx, :) = footR_Corrected;
    rigidBodyFit([1:3], footL_Idx, :) = footL_Corrected;
 
        %     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %     %%% Check the distance from torso. %%%
        %     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %     
        %     % Distance between Torso and Head.
        %     marker1            = squeeze(mean(torsoCorrected,2));
        %     marker2            = squeeze(mean(headCorrected,2));
        %     pairMarkerDistance = sqrt(sum((marker1-marker2).^2));
        %     figure; plot(pairMarkerDistance)
        %     
        %     % Distance between Torso and Hand.
        %     marker1            = squeeze(mean(torsoCorrected,2));
        %     marker2            = squeeze(mean(handCorrected,2));
        %     pairMarkerDistance = sqrt(sum((marker1-marker2).^2));
        %     figure; plot(pairMarkerDistance)
        %     
        %     % Distance between Torso and Right Foot.
        %     marker1            = squeeze(mean(torsoCorrected,2));
        %     marker2            = squeeze(mean(footR_Corrected,2));
        %     pairMarkerDistance = sqrt(sum((marker1-marker2).^2));
        %     figure; plot(pairMarkerDistance)
        %     
        %     % Distance between Torso and Left Foot.
        %     marker1            = squeeze(mean(torsoCorrected,2));
        %     marker2            = squeeze(mean(footL_Corrected,2));
        %     pairMarkerDistance = sqrt(sum((marker1-marker2).^2));
        %     figure; plot(pairMarkerDistance)
    
        
        
    %%%%%%%%%%%%%%%%%%
    %%% Save data. %%%
    %%%%%%%%%%%%%%%%%%
    EEG.etc.audiomaze.phaseSpaceCorrected = single(rigidBodyFit);
    EEG.etc.audiomaze.lessThanThreeLedMarkerIdx    = lessThanThreeMarkerIdx;
    EEG.etc.audiomaze.lessThanThreeLedMarkerLabels = lessThanThreeLedMarkerLabels;
    pop_saveset(EEG, 'filename', allSets(setIdx).name, 'filepath', '/data/mobi/Audiomaze/makoto/p02_fitRigidBody');
end