#include <iostream>

#include "rpcserver.hpp"
#include "cpphttplibconnector.hpp"

/*
  This fails:
  curl http://localhost:8483/jsonrpc -H "Content-Type application/json" --data '{ "method":"OptionOne", "params":{"e":"One"}, "id":10, "jsonrpc": "2.0" }'
  
  The error is "invalid parameter: must be object, but is string for parameter \"e\""


  This succeeds:
  curl http://localhost:8483/jsonrpc -H "Content-Type application/json" --data '{ "method":"OptionTwo", "params":{"s":"One"}, "id":10, "jsonrpc": "2.0" }'
 */

int main() {
  std::cout << "SimpleService" << std::endl;
  std::cout << "=============" << std::endl;

  SimpleService::RPCServer rpcServer;

  SimpleService::CppHttpLibServerConnector httpServer(rpcServer.rpcServer,
						      "0.0.0.0",
						      8483);
  
  std::cout << "Starting http server: "
            << std::boolalpha << httpServer.StartListening()
            << std::endl;
  
  std::cout << "Entering main loop" << std::endl;
  std::cout << "Type q to quit" << std::endl;
  bool done = false;
  while( !done ) {
    std::string inputLine;
    std::getline( std::cin, inputLine );
    if( inputLine == "q" ) {
      std::cout << "Received quit" << std::endl;
      done = true;
    }
  }
  
  return 0;
}
