#pragma once

#include <httplib.h>
#include <jsonrpccxx/iclientconnector.hpp>
#include <jsonrpccxx/server.hpp>
#include <string>

namespace SimpleService {

  //! Server for JSON RPC
  class CppHttpLibServerConnector {
  public:
    explicit CppHttpLibServerConnector(jsonrpccxx::JsonRpcServer& server,
				       std::string listenInterface,
				       int port);
    
    virtual ~CppHttpLibServerConnector() {
      this->StopListening();
    }
    
    bool StartListening();
    
    void StopListening();
    
  private:
    std::mutex listenMtx;
    std::thread thread;
    jsonrpccxx::JsonRpcServer& server;
    httplib::Server httpServer;
    std::string listenInterface;
    int port;
    
    void PostAction(const httplib::Request &req, httplib::Response &res);
  };
}
