import 'dart:async';

import 'package:flutter/widgets.dart';
import 'package:flutter/services.dart';

class Controller {

  static final MethodChannel _controlChannel = MethodChannel("io.flutter.add2apptest.control", JSONMethodCodec());

  static final GlobalKey<NavigatorState> navigatorKey = new GlobalKey<NavigatorState>();

  static Future<void> init() async {
    final Completer<void> initializingCompleter = Completer<void>();
    _controlChannel.setMethodCallHandler((MethodCall call) async {
      if (call.method == "initialized") {
        initializingCompleter.complete(null);
      }
      else if (call.method == "resetInitialRoute") {
        navigatorKey.currentState.pushNamedAndRemoveUntil(getInitialRoute(), (_) => false);
      }
    });
    await _controlChannel.invokeMethod("initialize");
    return initializingCompleter.future;
  }

  static MethodChannel getChannel() => _controlChannel;

  static String _initialRoute = '/';
  static String getInitialRoute() => _initialRoute;
}