﻿using System.Net;
using System.Net.Quic;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;

[System.Runtime.Versioning.SupportedOSPlatform("linux")]
internal class Program
{
    private static async Task Main(string[] args)
    {
        var listener = await QuicListener.ListenAsync(
            new QuicListenerOptions()
            {
                ApplicationProtocols = new List<SslApplicationProtocol> { new SslApplicationProtocol("foo") },
                ListenEndPoint = new IPEndPoint(IPAddress.Loopback, 12345),
                ConnectionOptionsCallback = (connection, clientInfo, cancel) => new(new QuicServerConnectionOptions()
                {
                    DefaultCloseErrorCode = 0,
                    DefaultStreamErrorCode = 0,
                    ServerAuthenticationOptions = new()
                    {
                        ApplicationProtocols = new List<SslApplicationProtocol> { new SslApplicationProtocol("foo") },
                        ClientCertificateRequired = false,
                        ServerCertificate = new X509Certificate2("server.p12", "password")
                    }
                })
            });

        var clientConnection = await QuicConnection.ConnectAsync(new QuicClientConnectionOptions()
        {
            DefaultCloseErrorCode = 0,
            DefaultStreamErrorCode = 0,
            RemoteEndPoint = new IPEndPoint(IPAddress.Loopback, 12345),
            ClientAuthenticationOptions = new SslClientAuthenticationOptions()
            {
                ApplicationProtocols = new List<SslApplicationProtocol> { new SslApplicationProtocol("foo") },
                RemoteCertificateValidationCallback = (sender, certificate, chain, errors) => true
            }
        });

        await using QuicConnection serverConnection = await listener.AcceptConnectionAsync();

        while (true)
        {
            bool remoteIsDisposed = false;
            _ = ReadAsync();

            await using var localStream = await clientConnection.OpenOutboundStreamAsync(QuicStreamType.Unidirectional);
            try
            {
                await localStream.WriteAsync(new byte[1]);
            }
            catch (QuicException exception)
            {
                Console.WriteLine($"unexpected write exception (remoteIsDisposed={remoteIsDisposed}): {exception}");
                return;
            }
            await localStream.DisposeAsync();

            async Task ReadAsync()
            {
                await using var remoteStream = await serverConnection.AcceptInboundStreamAsync();
                await remoteStream.ReadAsync(new byte[1]);
                await remoteStream.DisposeAsync();
                remoteIsDisposed = true;
            }
        }
    }
}
