"""
A Python dictionary containing information to be associated with the twelve keys on a
MacroPad.

** Understanding the Dictionary **
The following explains how to configure each entry below.

Label:
The label you would like to appear on the display. Should be limited to 5 characters to fit.

Keycode type:
You must update this to match the type of key sequence you"re sending. KL is used for strings.
KC = Keycode
CC = ConsumerControlCode
KL = keyboard_layout.write()

Key sequence:
The string, Keycode, sequence of Keycodes, or ConsumerControlCode to send.
"""
shortcut_keys = {
    "macros": [
        # (Label, Keycode type, Sequence)
        # 1st row ----------
        ("TFYC", "KL", ["Thanks for your contribution! "]),
        ("TFTF", "KL", ["Thanks for the fix! "]),
        ("TFDT", "KL", ["Thanks for doing this! "]),
        ("TY", "KL", ["Thank you! "]),
        # 2nd row ----------
        ("LGTM", "KL", ["Looks good to me. "]),
        ("DNT", "KL", ["Did not test. "]),
        ("ISSB", "KL", ["I've included some suggestions below. "]),
        ("TFTC", "KL", ["Thanks for the clarification. "]),
        # 3rd row ----------
        ("Nice", "KL", ["Nice. "]),
        ("C", "KL", ["Closing. "]),
        ("+1", "KL", [":+1: "]),
        ("Taco", "KL", [":taco: "]),
    ]
}
